<?php
require_once 'config.php';
if (isLoggedIn()) redirect('dashboard.php');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= SITE_NAME ?> - Automated Bot Trading</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --bg-dark: #1a1a2e; --bg-card: #16213e; --accent: #00d9ff; }
        body { background: var(--bg-dark); color: #fff; }
        .hero { min-height: 100vh; display: flex; align-items: center; }
        .btn-primary { background: linear-gradient(45deg, #00d9ff, #0066ff); border: none; padding: 12px 30px; }
        .btn-outline-light { border-color: var(--accent); color: var(--accent); }
        .btn-outline-light:hover { background: var(--accent); color: #000; }
        .feature-card { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); border-radius: 10px; padding: 30px; text-align: center; }
        .feature-card i { font-size: 3rem; color: var(--accent); margin-bottom: 20px; }
        .stats-section { background: var(--bg-card); padding: 60px 0; }
        .stat-box h2 { color: var(--accent); font-size: 3rem; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark fixed-top" style="background: rgba(26,26,46,0.9);">
        <div class="container">
            <a class="navbar-brand" href="#"><i class="fas fa-robot me-2"></i><?= SITE_NAME ?></a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="login.php">Login</a>
                <a class="btn btn-primary ms-2" href="register.php">Get Started</a>
            </div>
        </div>
    </nav>
    <section class="hero">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="display-4 fw-bold mb-4">Automated Trading<br><span style="color: var(--accent);">Made Simple</span></h1>
                    <p class="lead mb-4">Let our advanced AI trading bot work for you 24/7. Earn up to 6% daily returns with our automated trading strategies.</p>
                    <a href="register.php" class="btn btn-primary btn-lg me-3">Start Earning</a>
                    <a href="#features" class="btn btn-outline-light btn-lg">Learn More</a>
                </div>
                <div class="col-lg-6 text-center">
                    <i class="fas fa-robot" style="font-size: 15rem; color: var(--accent); opacity: 0.5;"></i>
                </div>
            </div>
        </div>
    </section>
    <section class="stats-section">
        <div class="container">
            <div class="row text-center">
                <div class="col-md-3"><div class="stat-box"><h2>$50M+</h2><p>Total Invested</p></div></div>
                <div class="col-md-3"><div class="stat-box"><h2>25K+</h2><p>Active Users</p></div></div>
                <div class="col-md-3"><div class="stat-box"><h2>99.9%</h2><p>Uptime</p></div></div>
                <div class="col-md-3"><div class="stat-box"><h2>24/7</h2><p>Bot Trading</p></div></div>
            </div>
        </div>
    </section>
    <section id="features" class="py-5">
        <div class="container">
            <h2 class="text-center mb-5">Why Choose Us?</h2>
            <div class="row">
                <div class="col-md-4 mb-4">
                    <div class="feature-card"><i class="fas fa-shield-alt"></i><h5>Secure Platform</h5><p>Your funds are protected with enterprise-grade security.</p></div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="feature-card"><i class="fas fa-chart-line"></i><h5>High Returns</h5><p>Earn up to 6% daily with our advanced trading algorithms.</p></div>
                </div>
                <div class="col-md-4 mb-4">
                    <div class="feature-card"><i class="fas fa-clock"></i><h5>24/7 Trading</h5><p>Our bots never sleep - always trading for maximum profit.</p></div>
                </div>
            </div>
        </div>
    </section>
    <footer class="py-4" style="background: var(--bg-card);"><div class="container text-center"><p class="mb-0">&copy; <?= date('Y') ?> <?= SITE_NAME ?>. All rights reserved.</p></div></footer>
</body>
</html>