<?php
require_once 'config.php';
if (!isLoggedIn()) redirect('login.php');
$user_id = $_SESSION['user_id'];
$error = $success = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $amount = (float)$_POST['amount'];
    if ($amount < 10) { $error = "Minimum deposit is $10"; }
    else {
        $conn->query("INSERT INTO transactions (user_id, type, amount, description) VALUES ($user_id, 'deposit', $amount, 'Deposit request')");
        $success = "Deposit request submitted! Please wait for admin approval.";
    }
}
$deposits = $conn->query("SELECT * FROM transactions WHERE user_id=$user_id AND type='deposit' ORDER BY created_at DESC LIMIT 10");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Deposit - <?= SITE_NAME ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root { --bg-dark: #1a1a2e; --bg-card: #16213e; --accent: #00d9ff; }
        body { background: var(--bg-dark); color: #fff; min-height: 100vh; }
        .navbar { background: var(--bg-card) !important; }
        .card { background: var(--bg-card); border: 1px solid rgba(255,255,255,0.1); }
        .btn-primary { background: linear-gradient(45deg, #00d9ff, #0066ff); border: none; }
        .form-control { background: rgba(255,255,255,0.1); border: 1px solid rgba(255,255,255,0.2); color: #fff; }
        .form-control:focus { background: rgba(255,255,255,0.15); color: #fff; }
        .table { color: #fff; }
    </style>
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark mb-4">
        <div class="container">
            <a class="navbar-brand" href="#"><i class="fas fa-robot me-2"></i><?= SITE_NAME ?></a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="dashboard.php">Dashboard</a>
                <a class="nav-link" href="invest.php">Invest</a>
                <a class="nav-link active" href="deposit.php">Deposit</a>
                <a class="nav-link" href="withdraw.php">Withdraw</a>
                <a class="nav-link" href="logout.php">Logout</a>
            </div>
        </div>
    </nav>
    <div class="container">
        <div class="row">
            <div class="col-md-6">
                <div class="card p-4 mb-4">
                    <h5 class="mb-3"><i class="fas fa-plus-circle me-2"></i>Make a Deposit</h5>
                    <?php if ($error): ?><div class="alert alert-danger"><?= $error ?></div><?php endif; ?>
                    <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
                    <form method="POST">
                        <div class="mb-3"><label class="form-label">Amount (USD)</label><input type="number" name="amount" class="form-control" min="10" step="0.01" required></div>
                        <div class="mb-3"><label class="form-label">Payment Method</label><select class="form-control"><option>Bitcoin (BTC)</option><option>Ethereum (ETH)</option><option>USDT (TRC20)</option></select></div>
                        <div class="alert alert-info"><small><strong>Note:</strong> After submitting, admin will provide wallet address and approve your deposit manually.</small></div>
                        <button type="submit" class="btn btn-primary w-100">Submit Deposit Request</button>
                    </form>
                </div>
            </div>
            <div class="col-md-6">
                <div class="card p-4">
                    <h5 class="mb-3"><i class="fas fa-history me-2"></i>Deposit History</h5>
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead><tr><th>Amount</th><th>Status</th><th>Date</th></tr></thead>
                            <tbody>
                            <?php while($dep = $deposits->fetch_assoc()): ?>
                                <tr><td><?= formatMoney($dep['amount']) ?></td><td><span class="badge bg-<?= $dep['status']=='approved'?'success':($dep['status']=='pending'?'warning':'danger') ?>"><?= ucfirst($dep['status']) ?></span></td><td><?= date('M d, Y', strtotime($dep['created_at'])) ?></td></tr>
                            <?php endwhile; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>