<?php
/**
 * cron.php - Run this via cron job every day
 * Example: 0 0 * * * php /path/to/cron.php
 */
require_once 'config.php';

$pairs = ['BTC/USDT', 'ETH/USDT', 'BNB/USDT', 'XRP/USDT', 'SOL/USDT', 'ADA/USDT', 'DOGE/USDT', 'DOT/USDT'];
$investments = $conn->query("SELECT i.*, u.id as uid FROM investments i JOIN users u ON i.user_id = u.id WHERE i.status = 'active'");
$processed = 0;

while ($inv = $investments->fetch_assoc()) {
    $user_id = $inv['user_id'];
    $inv_id = $inv['id'];
    $amount = $inv['amount'];
    $daily_rate = $inv['daily_profit'];
    $daily_profit = $amount * ($daily_rate / 100);

    $today = date('Y-m-d');
    $check = $conn->query("SELECT id FROM trades WHERE investment_id = $inv_id AND DATE(created_at) = '$today'");
    if ($check->num_rows > 0) continue;

    $num_trades = rand(3, 8);
    $remaining_profit = $daily_profit;

    for ($i = 0; $i < $num_trades; $i++) {
        $pair = $pairs[array_rand($pairs)];
        $type = rand(0, 1) ? 'buy' : 'sell';
        $trade_amount = $amount * (rand(5, 20) / 100);

        if ($i == $num_trades - 1) {
            $profit = $remaining_profit;
        } else {
            $is_winning = rand(1, 10) > 2;
            $profit = $is_winning ? $remaining_profit * (rand(10, 40) / 100) : -($daily_profit * (rand(5, 15) / 100));
            $remaining_profit -= $profit;
        }
        $profit = round($profit, 2);
        $conn->query("INSERT INTO trades (user_id, investment_id, pair, type, amount, profit) VALUES ($user_id, $inv_id, '$pair', '$type', $trade_amount, $profit)");
    }

    $conn->query("UPDATE investments SET earned = earned + $daily_profit WHERE id = $inv_id");
    $conn->query("UPDATE users SET balance = balance + $daily_profit, total_earned = total_earned + $daily_profit WHERE id = $user_id");
    $conn->query("INSERT INTO transactions (user_id, type, amount, status, description) VALUES ($user_id, 'profit', $daily_profit, 'approved', 'Daily trading profit')");

    if (strtotime($inv['end_date']) <= time()) {
        $conn->query("UPDATE users SET balance = balance + $amount WHERE id = $user_id");
        $conn->query("UPDATE investments SET status = 'completed' WHERE id = $inv_id");
        $conn->query("INSERT INTO transactions (user_id, type, amount, status, description) VALUES ($user_id, 'profit', $amount, 'approved', 'Investment principal returned')");
    }
    $processed++;
}
echo "Processed $processed investments at " . date('Y-m-d H:i:s');
?>