<?php
require_once '../config.php';
if (!isLoggedIn() || !isAdmin()) redirect('../login.php');
$success = '';
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    if (isset($_POST['add_plan'])) {
        $name = sanitize($_POST['name']); $min = (float)$_POST['min_amount']; $max = (float)$_POST['max_amount'];
        $daily = (float)$_POST['daily_profit']; $duration = (int)$_POST['duration'];
        $conn->query("INSERT INTO plans (name, min_amount, max_amount, daily_profit, duration_days) VALUES ('$name', $min, $max, $daily, $duration)");
        $success = "Plan added!";
    }
    if (isset($_POST['update_plan'])) {
        $id = (int)$_POST['plan_id']; $name = sanitize($_POST['name']); $min = (float)$_POST['min_amount'];
        $max = (float)$_POST['max_amount']; $daily = (float)$_POST['daily_profit'];
        $duration = (int)$_POST['duration']; $status = sanitize($_POST['status']);
        $conn->query("UPDATE plans SET name='$name', min_amount=$min, max_amount=$max, daily_profit=$daily, duration_days=$duration, status='$status' WHERE id=$id");
        $success = "Plan updated!";
    }
    if (isset($_POST['delete_plan'])) { $id = (int)$_POST['plan_id']; $conn->query("DELETE FROM plans WHERE id=$id"); $success = "Plan deleted!"; }
}
$plans = $conn->query("SELECT * FROM plans ORDER BY min_amount ASC");
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Plans - Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>:root{--bg-dark:#1a1a2e;--bg-card:#16213e;--accent:#00d9ff}body{background:var(--bg-dark);color:#fff}.sidebar{background:var(--bg-card);min-height:100vh;padding:20px}.sidebar a{color:#aaa;display:block;padding:10px;border-radius:5px;text-decoration:none;margin-bottom:5px}.sidebar a:hover,.sidebar a.active{background:rgba(0,217,255,0.2);color:var(--accent)}.card{background:var(--bg-card);border:1px solid rgba(255,255,255,0.1)}.table{color:#fff}.btn-primary{background:linear-gradient(45deg,#00d9ff,#0066ff);border:none}.form-control{background:rgba(255,255,255,0.1);border:1px solid rgba(255,255,255,0.2);color:#fff}.form-control:focus{background:rgba(255,255,255,0.15);color:#fff}.modal-content{background:var(--bg-card)}</style>
</head>
<body>
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-2 sidebar">
                <h4 class="mb-4"><i class="fas fa-robot me-2"></i>Admin</h4>
                <a href="index.php"><i class="fas fa-home me-2"></i>Dashboard</a>
                <a href="users.php"><i class="fas fa-users me-2"></i>Users</a>
                <a href="plans.php" class="active"><i class="fas fa-layer-group me-2"></i>Plans</a>
                <a href="deposits.php"><i class="fas fa-plus-circle me-2"></i>Deposits</a>
                <a href="withdrawals.php"><i class="fas fa-minus-circle me-2"></i>Withdrawals</a>
                <a href="investments.php"><i class="fas fa-chart-line me-2"></i>Investments</a>
                <hr><a href="../logout.php"><i class="fas fa-sign-out-alt me-2"></i>Logout</a>
            </div>
            <div class="col-md-10 p-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h4>Investment Plans</h4>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPlanModal"><i class="fas fa-plus me-2"></i>Add Plan</button>
                </div>
                <?php if ($success): ?><div class="alert alert-success"><?= $success ?></div><?php endif; ?>
                <div class="card p-3">
                    <table class="table"><thead><tr><th>Name</th><th>Min</th><th>Max</th><th>Daily %</th><th>Duration</th><th>Status</th><th>Actions</th></tr></thead><tbody>
                    <?php while($p = $plans->fetch_assoc()): ?>
                        <tr><td><?= $p['name'] ?></td><td><?= formatMoney($p['min_amount']) ?></td><td><?= formatMoney($p['max_amount']) ?></td><td><?= $p['daily_profit'] ?>%</td><td><?= $p['duration_days'] ?> days</td>
                            <td><span class="badge bg-<?= $p['status']=='active'?'success':'danger' ?>"><?= ucfirst($p['status']) ?></span></td>
                            <td><button class="btn btn-sm btn-info" onclick='editPlan(<?= json_encode($p) ?>)'>Edit</button>
                            <form method="POST" style="display:inline" onsubmit="return confirm('Delete?')"><input type="hidden" name="plan_id" value="<?= $p['id'] ?>"><button name="delete_plan" class="btn btn-sm btn-danger">Del</button></form></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody></table>
                </div>
            </div>
        </div>
    </div>
    <div class="modal fade" id="addPlanModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content p-4">
        <h5 class="mb-3">Add New Plan</h5>
        <form method="POST">
            <div class="mb-3"><label class="form-label">Plan Name</label><input type="text" name="name" class="form-control" required></div>
            <div class="row"><div class="col-6 mb-3"><label class="form-label">Min ($)</label><input type="number" name="min_amount" class="form-control" step="0.01" required></div>
            <div class="col-6 mb-3"><label class="form-label">Max ($)</label><input type="number" name="max_amount" class="form-control" step="0.01" required></div></div>
            <div class="row"><div class="col-6 mb-3"><label class="form-label">Daily %</label><input type="number" name="daily_profit" class="form-control" step="0.01" required></div>
            <div class="col-6 mb-3"><label class="form-label">Days</label><input type="number" name="duration" class="form-control" required></div></div>
            <button type="submit" name="add_plan" class="btn btn-primary w-100">Add Plan</button>
        </form>
    </div></div></div>
    <div class="modal fade" id="editPlanModal" tabindex="-1"><div class="modal-dialog"><div class="modal-content p-4">
        <h5 class="mb-3">Edit Plan</h5>
        <form method="POST"><input type="hidden" name="plan_id" id="edit_plan_id">
            <div class="mb-3"><label class="form-label">Plan Name</label><input type="text" name="name" id="edit_name" class="form-control" required></div>
            <div class="row"><div class="col-6 mb-3"><label class="form-label">Min ($)</label><input type="number" name="min_amount" id="edit_min" class="form-control" step="0.01" required></div>
            <div class="col-6 mb-3"><label class="form-label">Max ($)</label><input type="number" name="max_amount" id="edit_max" class="form-control" step="0.01" required></div></div>
            <div class="row"><div class="col-6 mb-3"><label class="form-label">Daily %</label><input type="number" name="daily_profit" id="edit_daily" class="form-control" step="0.01" required></div>
            <div class="col-6 mb-3"><label class="form-label">Days</label><input type="number" name="duration" id="edit_duration" class="form-control" required></div></div>
            <div class="mb-3"><label class="form-label">Status</label><select name="status" id="edit_status" class="form-control"><option value="active">Active</option><option value="inactive">Inactive</option></select></div>
            <button type="submit" name="update_plan" class="btn btn-primary w-100">Update</button>
        </form>
    </div></div></div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>function editPlan(p){document.getElementById('edit_plan_id').value=p.id;document.getElementById('edit_name').value=p.name;document.getElementById('edit_min').value=p.min_amount;document.getElementById('edit_max').value=p.max_amount;document.getElementById('edit_daily').value=p.daily_profit;document.getElementById('edit_duration').value=p.duration_days;document.getElementById('edit_status').value=p.status;new bootstrap.Modal(document.getElementById('editPlanModal')).show();}</script>
</body>
</html>